// Copyright 1994 by Jon Dart.
// arasavw.h : interface of the CArasanView class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __ARASAVW_H__
#define __ARASAVW_H__

class Display;
class ECO;
#include "options.h"
#include "search.h"
#include "square.h" 
#include "rmove.h"
#include "timectrl.h"

class CArasanDoc;
class ifstream;

class CArasanView : public CView
{
protected: // create from serialization only
        CArasanView();
        DECLARE_DYNCREATE(CArasanView)

// Attributes
public:
        CArasanDoc* GetDocument();

// Operations
public:

// Implementation
public:
        virtual ~CArasanView();
        virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
        virtual void AssertValid() const;
        virtual void Dump(CDumpContext& dc) const;
#endif
                     
                     
    void compute_move(Board &board, const Time_Info &ti,
            const BOOL background,
            Search::Statistics &stats,
            ExtendedMove &emove);

    void computer_plays( const ColorType side );

    virtual BOOL OnCommand( WPARAM, LPARAM );

    void draw_board();
    void show_side();
    
    ReversibleMove get_last_move() const
    {
        return last_move;
    }

    void terminate_search()
    {
        searcher->terminate_now();
    }

    const CString &get_eco() const
    {
        return eco;
    }

    const CString &get_opening_name() const
    {
        return opening_name;
    }

    const Search::Statistics & get_stats() const
    {
        return stats;
    }

    BOOL open_file(LPCSTR filename);

    enum ResetType {Initial, NewGame, NewPosition };

    void reset( ResetType );

    afx_msg void OnSearchComplete(BOOL makeMove);

protected:           

    void update_time();
    void update_board( const ExtendedMove &emove,
                       const Search::Statistics *stats,
                       const char *result,
                       const BOOL update_log);
    void show_last_move(char *move_image);
    void show_last_move();
    void setup_clock(const ColorType);
    void setup_clock_initially();
    void OnInitialUpdate();

    // Printing support 
  
    virtual void OnPrepareDC(CDC *pDC, CPrintInfo *pInfo);
    virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
    virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
    virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
    virtual void OnPrint(CDC *pDC, CPrintInfo *pInfo);

        // Generated message map functions
protected:
        //{{AFX_MSG(CArasanView)
        afx_msg void OnSize(UINT nType, int cx, int cy); 
        afx_msg void OnMove(int x, int y);
        afx_msg void OnPaint();
        afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
        afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
        afx_msg void OnMakeUserMove();
        afx_msg void OnComputeMove();
        afx_msg void OnTimer(UINT nIDEvent);
        afx_msg void OnSrclimits();
        afx_msg void OnFileOpen();
        afx_msg void OnFileSave();
        afx_msg void OnEditCopy();
        afx_msg void OnForward();
        afx_msg void OnHint();
        afx_msg void OnPause();
        afx_msg void OnPlaywhite();
        afx_msg void OnPreferences();
        afx_msg void OnReset();
        afx_msg void OnRotateboard();
        afx_msg void OnShowgame();
        afx_msg void OnTakeback();
        afx_msg void OnNewGame();
        afx_msg void OnFileExit();
        afx_msg void OnBackgroundCompute();
        afx_msg void OnAppAbout();
        afx_msg void OnBrowseNextgame();
        afx_msg void OnBrowsePreviousgame();
        afx_msg void OnBrowseSelectgame();
        afx_msg void OnLossOnTime();
        afx_msg void OnUpdateBrowseNextgame(CCmdUI* pCmdUI);
        afx_msg void OnUpdateBrowsePreviousgame(CCmdUI* pCmdUI);
        afx_msg void OnUpdateBrowseSelectgame(CCmdUI* pCmdUI);
        afx_msg void OnUpdatePlayWhite(CCmdUI* pCmdUI);
        afx_msg void OnUpdatePause(CCmdUI* pCmdUI);
        afx_msg void OnFileAnnotate();
        afx_msg void OnClose();
        afx_msg BOOL OnRecentFile(UINT nID);
        afx_msg void OnDropFiles(HDROP);
	afx_msg void OnUpdateHint(CCmdUI* pCmdUI);
	//}}AFX_MSG
        DECLARE_MESSAGE_MAP()
        
private:
        Board current_board;
        Display *disp;
        Square start_square;
        BOOL users_move, use_book, searching, no_prev_search, quitting,
             did_startup;
        UINT last_cmd;
        ReversibleMove last_move;
        ExtendedMove predicted_move;
        Search *searcher;
        Time_Control tc[Max_Time_Controls]; // Time limits
        Time_Info ti[2]; // Holds current time control for each side
        Search::Statistics stats;
        Search::Statistics bkgrnd_stats;
        ColorType computer_side;
        CString eco, opening_name, players;
        ECO *ecoCoder;
        BOOL file_opened;

        Board &get_board();
       
        void clear_status();      
        void load_pgn(ifstream &pgn_file, DWORD offset);
        void stop_search(BOOL makeMove);
        
        CWinThread *searchThread;
        BOOL background_search;
        CRITICAL_SECTION searchCritSection;
};

#ifndef _DEBUG  // debug version in arasavw.cpp
inline CArasanDoc* CArasanView::GetDocument()
   { return (CArasanDoc*)m_pDocument; }
#endif

#endif

/////////////////////////////////////////////////////////////////////////////
